<?php
/**
 * Add/Remove Friendship
 *
 * @package     AutomatorWP\Integrations\BuddyPress\Actions\User_Friendship
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyPress_User_Friendship extends AutomatorWP_Integration_Action {

    public $integration = 'buddypress';
    public $action = 'buddypress_user_friendship';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Start or stop a friendship', 'automatorwp-pro' ),
            'select_option'     => __( 'Start or stop a <strong>friendship</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Group. */
            'edit_label'        => sprintf( __( '%1$s a %2$s', 'automatorwp-pro' ), '{operation}', '{friendship}' ),
            /* translators: %1$s: Group. */
            'log_label'         => sprintf( __( '%1$s a %2$s', 'automatorwp-pro' ), '{operation}', '{friendship}' ),
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'start'     => __( 'Start', 'automatorwp-pro' ),
                                'stop'    => __( 'Stop', 'automatorwp-pro' ),
                            ),
                            'default' => 'start'
                        ),
                    )
                ),
                'friendship' => array(
                    'default' => __( 'friendship', 'automatorwp-pro' ),
                    'fields' => array(
                        'from' => array(
                            'name' => __( 'From:', 'automatorwp-pro' ),
                            'desc' => __( 'The user ID that starts or stops the friendship. Leave blank to assign the user who completed the automation.', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                        'to' => array(
                            'name' => __( 'To:', 'automatorwp-pro' ),
                            'desc' => __( 'The user ID that will receive the friendship. Leave blank to assign the user who completed the automation.', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                        'force' => array(
                            'name' => __( 'Force acceptance:', 'automatorwp-pro' ),
                            'desc' => __( 'Check this option to automatically accept the friendship (only used when <strong>starting</strong> a new friendship).', 'automatorwp-pro' ),
                            'type' => 'checkbox',
                            'classes' => 'cmb2-switch',
                        ),
                    ),
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $operation = $action_options['operation'];
        $from = $action_options['from'];
        $to = $action_options['to'];
        $force = $action_options['force'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'start';
        }

        // Setup the user IDs
        if( empty( $from ) ) {
            $from = $user_id;
        }

        if( empty( $to ) ) {
            $to = $user_id;
        }

        $from = absint( $from );
        $to = absint( $to );

        // Bail if no correctly setup
        if( $from === 0 || $to === 0 ) {
            return;
        }

        // Bail if from and to users are the same one
        if( $from === $to ) {
            return;
        }

        switch( $operation ) {
            case 'start':
                if ( function_exists( 'friends_add_friend' ) ) {
                    friends_add_friend( $from, $to, (bool) $force );
                }
                break;
            case 'stop':
                if ( function_exists( 'friends_remove_friend' ) ) {
                    friends_remove_friend( $from, $to );
                }
                break;
        }

    }

}

new AutomatorWP_BuddyPress_User_Friendship();